﻿var dataView = {
    context: $(".v-data-views"),
    datatable: null,
    treeview: null,
    projectId: null,
    initializeTreeView: function () {
        this.treeview = $(".h-dataFolders", this.context).a4listview({
            ajaxAction: a4.getProjectAction("GetDataViewFolders", "Data"),
            properties: {
                Label: "ViewTitle"
            },
            stateKey: "DataViews",
            draw: function (event, data) {
                var folder = data.selectedNode;
            },
            selectNode: function (event, data) {
                if (data.selected)
                    a4.callServerMethod(a4.getProjectAction("GetDataView", "Data", { dataViewId: data.node.Id }), null,
                        function (result) {
                            $("head style:last-child").remove();

                            var css = document.createElement('style');
                            css.type = 'text/css';
                            if (css.styleSheet)
                                css.styleSheet.cssText = result.response.Css;
                            else
                                css.appendChild(document.createTextNode(result.response.Css));
                            document.getElementsByTagName("head")[0].appendChild(css);

                            $(".h-dataViews-view", dataView.context).html(result.response.Html);
                        }
                    );
            },
            icons: {
                Custom: [
                    { Icon: "search" }
                ]
            },
            expanded: true,
            displaySearchBox: false,
            altValueField: $("#DataViewId")
        });
    },
    bindEvents: function () {

        $(".h-export").on("click", dataView.context, function () {
            if ($("#DataViewId").val() == 0) {
                a4.showErrorMessage(resources.ErrorNoDataViewSelected);
            }
            else {
                dataView.exportExcel();
            }

        });
    },
    exportExcel: function () {
        window.location = a4.getProjectAction("ExportToExcel", "Data", { dataViewId: $("#DataViewId").val() });
    }
}

$(document).ready(function () {
    if (dataView.context.length > 0) {
        dataView.projectId = $("#ProjectId").val();
        dataView.initializeTreeView();
        dataView.bindEvents();
    }
});


